<%@ Application Language="VB" %>
<%@ Import Namespace="System.Net.Mail" %>
<%@ Import Namespace="System.Security.Principal" %>

<script RunAt="server">

  Sub Application_Start(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany przy starcie aplikacji
  End Sub
    
  Sub Application_End(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany przy zamykaniu aplikacji
  End Sub
        
  Sub Application_Error(ByVal sender As Object, ByVal e As EventArgs)
    ' Uruchamia si po wystpieniu bdu
    Dim sendMailOnErrors As Boolean = False
    If sendMailOnErrors Then
      Dim subject As String = "Error in page " & Request.Url.ToString()
      Dim errorMessage As StringBuilder = New StringBuilder
      ' Bd, ktry wystpi na stronie www jest opakowywany w standardowy wyjtek System.Web.HttpUnhandledException
      ' Dlatego musimy si dosta do prawdziwego wyjtku, dostpnego jako InnerException
      Dim myException As Exception = HttpContext.Current.Server.GetLastError()
      If myException IsNot Nothing Then
        Do While myException IsNot Nothing
          errorMessage.Append("<strong>Message</strong><br />" & _
              myException.Message & "<br /><br />")
          errorMessage.Append("<strong>Source</strong><br />" & _
              myException.Source & "<br /><br />")
          errorMessage.Append("<strong>Target site</strong><br />" & _
              myException.TargetSite.ToString() & "<br /><br />")
          errorMessage.Append("<strong>Stack trace</strong><br />" & _
              myException.StackTrace & "<br /><br />")
          errorMessage.Append("<strong>ToString()</strong><br />" & _
              myException.ToString() & "<br /><br />")
          myException = myException.InnerException
        Loop
      Else
        errorMessage.Append("No exception information available.")
      End If

      ' Po skomponowaniu errorMessage, wylij wiadomo e-mail.
      Dim mySmtpClient As SmtpClient = New SmtpClient()
      Dim myMessage As MailMessage = New MailMessage( _
          AppConfiguration.EmailFrom, AppConfiguration.EmailTo, subject, _
          errorMessage.ToString())
      myMessage.IsBodyHtml = True

      mySmtpClient.Send(myMessage)
    End If
  End Sub

  Sub Session_Start(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany po rozpoczciu nowej sesji
  End Sub

  Sub Session_End(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany, kiedy sesja koczy si.
    ' Uwaga: Zdarzenie Session_End jest wywoywane tylko wwczas gdy tryb stanu sesji
    ' jest ustawiony na InProc w pliku Web.config. Jeli tryb sesji jest ustawiony na StateServer
    ' lub SQLServer zdarzenie nie jest wywoywane.
  End Sub
  
  Sub Application_AuthenticateRequest(ByVal sender As Object, ByVal e As EventArgs)
    If User IsNot Nothing AndAlso User.Identity.IsAuthenticated Then
      If System.Web.Security.Roles.Enabled = False Then
        Dim id As FormsIdentity = CType(User.Identity, FormsIdentity)
        Dim ticket As FormsAuthenticationTicket = id.Ticket

        Dim roleAsString As String = ticket.UserData
        Dim roles() As String = roleAsString.Split(New Char() {","})
        Context.User = New GenericPrincipal(Context.User.Identity, roles)
      End If
    End If
  End Sub
       
</script>

